#ifndef SIMPLESERIAL_SIMULATION_DATA_GENERATOR
#define SIMPLESERIAL_SIMULATION_DATA_GENERATOR

#include <SimulationChannelDescriptor.h>
#include <string>
class SimpleSerialAnalyzerSettings;

class SimpleSerialSimulationDataGenerator
{
public:
	SimpleSerialSimulationDataGenerator();
	~SimpleSerialSimulationDataGenerator();

	void Initialize( U32 simulation_sample_rate, SimpleSerialAnalyzerSettings* settings );
	U32 GenerateSimulationData( U64 newest_sample_requested, U32 sample_rate, SimulationChannelDescriptor** simulation_channels );

protected:
	SimpleSerialAnalyzerSettings* mSettings;
	U32 mSimulationSampleRateHz;

protected:

	SimulationChannelDescriptorGroup mChannels;
	SimulationChannelDescriptor *mChan1SimData;
	SimulationChannelDescriptor *mChan5SimData;

private:
	void Transition1(void);
	void Transition5(void);
	void TransitionNone(void);

	void Prologue(void);
	void Epilogue(void);

	void Byte(U8 val);

	void CreateSampleTransaction(const U32 *data, size_t numWords);
};
#endif //SIMPLESERIAL_SIMULATION_DATA_GENERATOR